// Mobile Menu Toggle
document.addEventListener('DOMContentLoaded', function() {
    const mobileMenuToggle = document.getElementById('mobileMenuToggle');
    const nav = document.querySelector('.nav');

    if (mobileMenuToggle) {
        mobileMenuToggle.addEventListener('click', () => {
            nav.classList.toggle('mobile-active');
        });
    }

    // Login Form Handler
    const loginForm = document.getElementById('loginForm');
    if (loginForm) {
        loginForm.addEventListener('submit', (e) => {
            e.preventDefault();
            const username = document.getElementById('username').value;
            const password = document.getElementById('password').value;
            
            if (username) {
                // Save username to localStorage
                localStorage.setItem('chatUsername', username);
                // Redirect to Mobil
                window.location.href = 'Mobil/';
            } else {
                alert('Lütfen kullanıcı adınızı girin!');
            }
        });
    }

    // Smooth Scroll
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });

    // Animate on scroll
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
            }
        });
    }, observerOptions);

    // Observe feature cards
    document.querySelectorAll('.feature-card').forEach(card => {
        card.style.opacity = '0';
        card.style.transform = 'translateY(30px)';
        card.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
        observer.observe(card);
    });

    // Mobil cihazlar için Sohbete Katıl butonu touch event
    const sohbetBtn = document.querySelector('.sohbet-katil-btn');
    if (sohbetBtn) {
        let touchStartTime = 0;
        let isRotating = false;

        // Touch start
        sohbetBtn.addEventListener('touchstart', function(e) {
            touchStartTime = Date.now();
            if (!isRotating) {
                this.style.animation = 'sohbetBtnRotate 1s ease forwards';
                const icon = this.querySelector('.sohbet-icon');
                if (icon) {
                    icon.style.animation = 'iconRotate390 1s ease forwards';
                }
                isRotating = true;
                
                // 1 saniye sonra animasyonu sıfırla (tekrar çalıştırmak için)
                setTimeout(() => {
                    isRotating = false;
                }, 1000);
            }
        }, { passive: true });

        // Touch end - hafif feedback
        sohbetBtn.addEventListener('touchend', function(e) {
            const touchDuration = Date.now() - touchStartTime;
            if (touchDuration < 300) {
                // Kısa dokunma - animasyon zaten başladı
                this.style.transform = 'translateY(-3px) scale(1.05) rotate(390deg)';
            }
        }, { passive: true });

        // Mobilde animasyonun sürekli çalışması için (isteğe bağlı)
        if (window.matchMedia('(hover: none) and (pointer: coarse)').matches) {
            // Mobil cihaz tespit edildi
            // Animasyon zaten CSS'te tanımlı
        }
    }
});

console.log('Tutku.org yüklendi! 💬');

