<?php
/**
 * The template for displaying archive pages
 *
 * @package TutkuOrg
 */

get_header();
?>

<main class="main-content">
    <header class="page-header" style="background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 50%, var(--purple) 100%); padding: 4rem 0; text-align: center; color: var(--white);">
        <div class="container">
            <?php
            the_archive_title('<h1 class="page-title" style="font-size: 3rem; font-weight: 800; margin-bottom: 1rem; text-shadow: 2px 2px 10px rgba(0, 0, 0, 0.2);">', '</h1>');
            the_archive_description('<div class="archive-description" style="font-size: 1.2rem; opacity: 0.9;">', '</div>');
            ?>
        </div>
    </header>

    <div class="container" style="padding: 4rem 0;">
        <?php
        if (have_posts()) :
            ?>
            <div class="posts-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(350px, 1fr)); gap: 2rem;">
                <?php
                while (have_posts()) :
                    the_post();
                    ?>
                    <article id="post-<?php the_ID(); ?>" <?php post_class('feature-card'); ?>>
                        <?php if (has_post_thumbnail()) : ?>
                            <a href="<?php the_permalink(); ?>">
                                <?php the_post_thumbnail('medium', array('style' => 'width: 100%; height: auto; border-radius: 15px 15px 0 0;')); ?>
                            </a>
                        <?php endif; ?>
                        
                        <div style="padding: 2rem;">
                            <h2 class="feature-title" style="margin-bottom: 1rem;">
                                <a href="<?php the_permalink(); ?>" style="color: var(--text); text-decoration: none;">
                                    <?php the_title(); ?>
                                </a>
                            </h2>
                            
                            <div class="entry-meta" style="font-size: 0.9rem; color: var(--text-gray); margin-bottom: 1rem;">
                                <span class="posted-on">
                                    <i class="fas fa-calendar"></i> <?php echo get_the_date(); ?>
                                </span>
                            </div>
                            
                            <div class="entry-content" style="color: var(--text-gray); margin-bottom: 1.5rem;">
                                <?php the_excerpt(); ?>
                            </div>
                            
                            <a href="<?php the_permalink(); ?>" class="btn btn-primary" style="display: inline-block;">
                                Devamını Oku
                            </a>
                        </div>
                    </article>
                    <?php
                endwhile;
                ?>
            </div>

            <?php
            // Pagination
            the_posts_pagination(array(
                'mid_size' => 2,
                'prev_text' => __('« Önceki', 'tutkuorg'),
                'next_text' => __('Sonraki »', 'tutkuorg'),
            ));

        else :
            ?>
            <p><?php esc_html_e('İçerik bulunamadı.', 'tutkuorg'); ?></p>
            <?php
        endif;
        ?>
    </div>
</main>

<?php
get_footer();
?>

