<!-- Footer -->
<footer class="footer">
    <div class="container">
        <div class="footer-content">
            <div class="footer-section">
                <h4 class="footer-title"><?php bloginfo('name'); ?></h4>
                <p class="footer-description">Bedava sohbet odaları ile yeni arkadaşlıklar kur, keyifli sohbetler yap!</p>
            </div>
            <div class="footer-section">
                <h4 class="footer-title">Hızlı Linkler</h4>
                <ul class="footer-links">
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'footer',
                        'container' => false,
                        'menu_class' => 'footer-links',
                        'fallback_cb' => 'tutkuorg_footer_menu',
                        'items_wrap' => '%3$s',
                    ));
                    ?>
                </ul>
            </div>
            <div class="footer-section">
                <h4 class="footer-title">Bize Ulaşın</h4>
                <ul class="footer-contact">
                    <li>
                        <i class="fas fa-envelope"></i>
                        <a href="mailto:info@tutku.org">info@tutku.org</a>
                    </li>
                    <li>
                        <i class="fas fa-clock"></i>
                        <span>7/24 Aktif</span>
                    </li>
                </ul>
            </div>
        </div>
        <div class="footer-bottom">
            <p>&copy; <?php echo date('Y'); ?> <?php bloginfo('name'); ?> - Tüm Hakları Saklıdır.</p>
            <p class="design-credit-text">Bu Tema <a href="https://direkhizmet.com" target="_blank" rel="noopener noreferrer" style="text-decoration: none;"><strong style="background: linear-gradient(135deg, #E91E63 0%, #FF5722 30%, #9C27B0 60%, #E91E63 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; transition: all 0.3s ease; display: inline-block;">DirekHizmet.com</strong></a> tarafından yapılmıştır</p>
        </div>
    </div>
</footer>

<?php wp_footer(); ?>
</body>
</html>

<?php
// Default footer menu
function tutkuorg_footer_menu() {
    echo '<li><a href="' . esc_url(home_url('/')) . '">Anasayfa</a></li>';
    $pages = get_pages(array('sort_column' => 'menu_order', 'number' => 5));
    foreach ($pages as $page) {
        echo '<li><a href="' . esc_url(get_permalink($page->ID)) . '">' . esc_html($page->post_title) . '</a></li>';
    }
}
?>

