<?php
/**
 * The front page template
 *
 * @package TutkuOrg
 */

get_header();
?>

<!-- Hero Section -->
<section class="hero">
    <div class="hero-overlay"></div>
    <div class="container">
        <div class="hero-content">
            <h1 class="hero-title">Tutku.org Sohbetin Yeni Adresi</h1>
            <p class="hero-subtitle">Bugün sizlere internet dünyasında yeni bir soluk getiren Tutku.org sitesinden bahsetmek istiyorum.</p>
            <div class="hero-buttons">
                <a href="<?php echo esc_url(home_url('/Mobil/')); ?>" class="btn btn-primary">
                    <i class="fas fa-comments"></i> Sohbete Katıl
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Main Content -->
<main class="main-content">
    <!-- Info Section -->
    <section class="info-section">
        <div class="container">
            <div class="info-content">
                <h2 class="info-title">Tutku.org Nedir</h2>
                <p class="info-text">
                    Tutku.org, farklı ilgi alanlarına sahip bireylerin bir araya gelerek fikir alışverişinde bulunabileceği, arkadaşlıklar kurabileceği bir sohbet platformudur. Site, kullanıcılarına anlık mesajlaşma, sesli sohbet ve çeşitli konularda forumlar sunarak geniş bir etkileşim alanı sağlar.
                </p>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="features-section">
        <div class="container">
            <div class="section-header">
                <h2 class="section-title">Neden Tutku.org</h2>
                <p class="section-subtitle">Sizlere sunduğumuz avantajlar</p>
            </div>
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-list"></i>
                    </div>
                    <h3 class="feature-title">Kapsamlı Konu Başlıkları</h3>
                    <p class="feature-description">Tutku.org, kullanıcılarına geniş bir yelpazede konu başlıkları sunar. İster teknoloji, ister sanat ya da günlük yaşam konularında sohbet etmek isteyin, burada mutlaka ilginizi çekecek bir başlık bulabilirsiniz.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-mouse-pointer"></i>
                    </div>
                    <h3 class="feature-title">Kolay Kullanım</h3>
                    <p class="feature-description">Kullanıcı dostu arayüzü sayesinde, siteye yeni kaydolan bir üye bile kısa sürede alışabilir. Sohbet odaları arasında geçiş yapmak ve yeni arkadaşlar edinmek oldukça basittir.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h3 class="feature-title">Güvenli Ortam</h3>
                    <p class="feature-description">Tutku.org, kullanıcılarının güvenliğini ön planda tutar. Kişisel verileriniz korunur ve rahatsız edici davranışlar sergileyen kullanıcılar için etkili moderasyon sistemleri mevcuttur.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-calendar-alt"></i>
                    </div>
                    <h3 class="feature-title">Çeşitli Etkinlikler</h3>
                    <p class="feature-description">Site, kullanıcılarını bir araya getiren çeşitli online etkinlikler düzenler. Bu etkinlikler sayesinde hem eğlenebilir hem de yeni insanlarla tanışabilirsiniz.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Quote Section -->
    <section class="quote-section">
        <div class="container">
            <div class="quote-content">
                <h2 class="quote-title">Sohbet Keyfi</h2>
                <p class="quote-text">
                    Sohbet etmek, insanların hayatında önemli bir yere sahiptir. Gündelik streslerden uzaklaşmak, yeni şeyler öğrenmek ve farklı bakış açıları kazanmak için sohbet etmek harika bir yoldur. Tutku.org, bu keyfi yaşamak isteyen herkesi bekliyor.
                </p>
            </div>
        </div>
    </section>
</main>

<?php
get_footer();
?>

