<?php
/**
 * TutkuOrg Theme Functions
 *
 * @package TutkuOrg
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Theme Setup
 */
function tutkuorg_setup() {
    // Add theme support
    add_theme_support('title-tag');
    add_theme_support('post-thumbnails');
    add_theme_support('html5', array(
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
    ));
    add_theme_support('custom-logo');
    add_theme_support('automatic-feed-links');
    
    // Register navigation menus
    register_nav_menus(array(
        'primary' => __('Primary Menu', 'tutkuorg'),
        'footer' => __('Footer Menu', 'tutkuorg'),
    ));
}
add_action('after_setup_theme', 'tutkuorg_setup');

/**
 * Enqueue scripts and styles
 */
function tutkuorg_scripts() {
    // Enqueue Font Awesome
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css', array(), '6.4.0');
    
    // Enqueue theme stylesheet
    wp_enqueue_style('tutkuorg-style', get_stylesheet_uri(), array(), '1.0.0');
    wp_enqueue_style('tutkuorg-main-style', get_template_directory_uri() . '/assets/css/style.css', array('tutkuorg-style'), '1.0.0');
    
    // Enqueue theme JavaScript
    wp_enqueue_script('tutkuorg-main', get_template_directory_uri() . '/assets/js/main.js', array(), '1.0.0', true);
    
    // Localize script for AJAX
    wp_localize_script('tutkuorg-main', 'tutkuorgData', array(
        'ajaxUrl' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('tutkuorg-nonce'),
        'homeUrl' => home_url('/'),
    ));
}
add_action('wp_enqueue_scripts', 'tutkuorg_scripts');

/**
 * Register widget areas
 */
function tutkuorg_widgets_init() {
    register_sidebar(array(
        'name' => __('Sidebar', 'tutkuorg'),
        'id' => 'sidebar-1',
        'description' => __('Add widgets here.', 'tutkuorg'),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget' => '</section>',
        'before_title' => '<h2 class="widget-title">',
        'after_title' => '</h2>',
    ));
}
add_action('widgets_init', 'tutkuorg_widgets_init');

/**
 * Custom excerpt length
 */
function tutkuorg_excerpt_length($length) {
    return 30;
}
add_filter('excerpt_length', 'tutkuorg_excerpt_length');

/**
 * Custom excerpt more
 */
function tutkuorg_excerpt_more($more) {
    return '...';
}
add_filter('excerpt_more', 'tutkuorg_excerpt_more');

/**
 * Add theme color meta tag
 */
function tutkuorg_theme_color() {
    echo '<meta name="theme-color" content="#E91E63">';
}
add_action('wp_head', 'tutkuorg_theme_color');

/**
 * Add favicon
 */
function tutkuorg_favicon() {
    $favicon = 'data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 100 100\'%3E%3Cdefs%3E%3ClinearGradient id=\'grad\' x1=\'0%25\' y1=\'0%25\' x2=\'100%25\' y2=\'100%25\'%3E%3Cstop offset=\'0%25\' style=\'stop-color:%23E91E63;stop-opacity:1\' /%3E%3Cstop offset=\'50%25\' style=\'stop-color:%23FF5722;stop-opacity:1\' /%3E%3Cstop offset=\'100%25\' style=\'stop-color:%239C27B0;stop-opacity:1\' /%3E%3C/linearGradient%3E%3CradialGradient id=\'glow\' cx=\'50%25\' cy=\'50%25\' r=\'50%25\'%3E%3Cstop offset=\'0%25\' style=\'stop-color:%23FF4081;stop-opacity:0.7\' /%3E%3Cstop offset=\'100%25\' style=\'stop-color:%23E91E63;stop-opacity:0.4\' /%3E%3C/radialGradient%3E%3C/defs%3E%3Ccircle cx=\'50\' cy=\'50\' r=\'48\' fill=\'url(%23glow)\'/%3E%3Ccircle cx=\'50\' cy=\'50\' r=\'42\' fill=\'url(%23grad)\'/%3E%3Cpath d=\'M50 25 L58 40 L75 42 L63 52 L68 68 L50 58 L32 68 L37 52 L25 42 L42 40 Z\' fill=\'white\' opacity=\'0.95\'/%3E%3Ccircle cx=\'50\' cy=\'50\' r=\'38\' fill=\'none\' stroke=\'white\' stroke-width=\'2\' opacity=\'0.5\'/%3E%3C/svg%3E';
    echo '<link rel="icon" type="image/svg+xml" href="' . esc_url($favicon) . '">';
    echo '<link rel="apple-touch-icon" href="' . esc_url($favicon) . '">';
}
add_action('wp_head', 'tutkuorg_favicon');

