<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0, user-scalable=yes">
    <meta name="format-detection" content="telephone=no">
    
    <?php if (is_front_page()) : ?>
        <meta name="description" content="Tutku.org - Bedava sohbet odaları, canlı chat. Yeni arkadaşlıklar için buradayız!">
        <meta name="keywords" content="tutku, tutku.org, sohbet, chat, bedava sohbet, canlı sohbet, sohbet odaları, online sohbet">
        <link rel="canonical" href="<?php echo esc_url(home_url('/')); ?>">
        
        <!-- Open Graph -->
        <meta property="og:type" content="website">
        <meta property="og:url" content="<?php echo esc_url(home_url('/')); ?>">
        <meta property="og:title" content="Tutku.org - Bedava Sohbet Odaları">
        <meta property="og:description" content="Tutku.org - Bedava sohbet odaları, canlı chat. Yeni arkadaşlıklar için buradayız!">
        <meta property="og:locale" content="tr_TR">
        <meta property="og:site_name" content="Tutku.org">
        
        <!-- Twitter Card -->
        <meta name="twitter:card" content="summary_large_image">
        <meta name="twitter:title" content="Tutku.org - Bedava Sohbet Odaları">
        <meta name="twitter:description" content="Tutku.org - Bedava sohbet odaları, canlı chat. Yeni arkadaşlıklar için buradayız!">
        
        <!-- Structured Data -->
        <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "WebSite",
            "name": "Tutku.org",
            "url": "<?php echo esc_url(home_url('/')); ?>",
            "description": "Bedava sohbet odaları, canlı chat. Yeni arkadaşlıklar için buradayız!",
            "potentialAction": {
                "@type": "SearchAction",
                "target": "<?php echo esc_url(home_url('/?s={search_term_string}')); ?>",
                "query-input": "required name=search_term_string"
            }
        }
        </script>
        <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "Organization",
            "name": "Tutku.org",
            "url": "<?php echo esc_url(home_url('/')); ?>",
            "contactPoint": {
                "@type": "ContactPoint",
                "email": "info@tutku.org"
            }
        }
        </script>
    <?php endif; ?>
    
    <!-- Mobile Optimizations -->
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="Tutku.org">
    
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<!-- Header -->
<header class="header">
    <div class="container">
        <div class="header-content">
            <a href="<?php echo esc_url(home_url('/')); ?>" class="logo">
                <i class="fas fa-comments"></i>
                <span class="logo-text">Tutku<strong>.org</strong></span>
            </a>
            <nav class="nav">
                <?php
                wp_nav_menu(array(
                    'theme_location' => 'primary',
                    'container' => false,
                    'menu_class' => '',
                    'fallback_cb' => 'tutkuorg_default_menu',
                    'items_wrap' => '<ul>%3$s</ul>',
                ));
                ?>
            </nav>
            <button class="mobile-menu-toggle" id="mobileMenuToggle">
                <i class="fas fa-bars"></i>
            </button>
        </div>
    </div>
</header>

<?php
// Default menu if no menu is assigned
function tutkuorg_default_menu() {
    echo '<ul>';
    echo '<li><a href="' . esc_url(home_url('/')) . '" class="' . (is_front_page() ? 'active' : '') . '">Anasayfa</a></li>';
    
    $pages = get_pages(array('sort_column' => 'menu_order'));
    foreach ($pages as $page) {
        $page_url = get_permalink($page->ID);
        $is_active = (is_page($page->ID)) ? 'active' : '';
        echo '<li><a href="' . esc_url($page_url) . '" class="' . $is_active . '">' . esc_html($page->post_title) . '</a></li>';
    }
    echo '</ul>';
}
?>

