<?php
/**
 * The main template file
 *
 * @package TutkuOrg
 */

get_header();
?>

<main class="main-content">
    <?php
    if (have_posts()) :
        while (have_posts()) :
            the_post();
            ?>
            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <header class="entry-header">
                    <h1 class="entry-title">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h1>
                    <div class="entry-meta">
                        <span class="posted-on"><?php echo get_the_date(); ?></span>
                        <span class="byline"><?php the_author(); ?></span>
                    </div>
                </header>

                <div class="entry-content">
                    <?php the_excerpt(); ?>
                </div>

                <footer class="entry-footer">
                    <a href="<?php the_permalink(); ?>" class="btn btn-primary">Devamını Oku</a>
                </footer>
            </article>
            <?php
        endwhile;

        // Pagination
        the_posts_pagination(array(
            'mid_size' => 2,
            'prev_text' => __('« Önceki', 'tutkuorg'),
            'next_text' => __('Sonraki »', 'tutkuorg'),
        ));

    else :
        ?>
        <p><?php esc_html_e('İçerik bulunamadı.', 'tutkuorg'); ?></p>
        <?php
    endif;
    ?>
</main>

<?php
get_footer();
?>

