<?php
/**
 * The template for displaying all pages
 *
 * @package TutkuOrg
 */

get_header();
?>

<main class="main-content">
    <?php
    while (have_posts()) :
        the_post();
        ?>
        
        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <header class="page-header" style="background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 50%, var(--purple) 100%); padding: 4rem 0; text-align: center; color: var(--white);">
                <div class="container">
                    <h1 class="page-title" style="font-size: 3rem; font-weight: 800; margin-bottom: 1rem; text-shadow: 2px 2px 10px rgba(0, 0, 0, 0.2);">
                        <?php the_title(); ?>
                    </h1>
                </div>
            </header>

            <div class="container" style="padding: 4rem 0;">
                <div class="page-content" style="max-width: 900px; margin: 0 auto;">
                    <?php
                    if (has_post_thumbnail()) {
                        the_post_thumbnail('large', array('style' => 'width: 100%; height: auto; border-radius: 15px; margin-bottom: 2rem;'));
                    }
                    ?>

                    <div class="entry-content" style="font-size: 1.1rem; line-height: 1.8; color: var(--text);">
                        <?php
                        the_content();

                        wp_link_pages(array(
                            'before' => '<div class="page-links">' . esc_html__('Sayfalar:', 'tutkuorg'),
                            'after'  => '</div>',
                        ));
                        ?>
                    </div>
                </div>
            </div>
        </article>

        <?php
        // If comments are open or we have at least one comment, load up the comment template.
        if (comments_open() || get_comments_number()) :
            comments_template();
        endif;

    endwhile; // End of the loop.
    ?>
</main>

<?php
get_footer();
?>

