<?php
/**
 * The template for displaying all single posts
 *
 * @package TutkuOrg
 */

get_header();
?>

<main class="main-content">
    <?php
    while (have_posts()) :
        the_post();
        ?>
        
        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <header class="entry-header" style="background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 50%, var(--purple) 100%); padding: 4rem 0; text-align: center; color: var(--white);">
                <div class="container">
                    <h1 class="entry-title" style="font-size: 3rem; font-weight: 800; margin-bottom: 1rem; text-shadow: 2px 2px 10px rgba(0, 0, 0, 0.2);">
                        <?php the_title(); ?>
                    </h1>
                    <div class="entry-meta" style="font-size: 1rem; opacity: 0.9;">
                        <span class="posted-on">
                            <i class="fas fa-calendar"></i> <?php echo get_the_date(); ?>
                        </span>
                        <span class="byline" style="margin-left: 1.5rem;">
                            <i class="fas fa-user"></i> <?php the_author(); ?>
                        </span>
                    </div>
                </div>
            </header>

            <div class="container" style="padding: 4rem 0;">
                <div class="entry-content" style="max-width: 900px; margin: 0 auto; font-size: 1.1rem; line-height: 1.8; color: var(--text);">
                    <?php
                    if (has_post_thumbnail()) {
                        the_post_thumbnail('large', array('style' => 'width: 100%; height: auto; border-radius: 15px; margin-bottom: 2rem;'));
                    }

                    the_content();

                    wp_link_pages(array(
                        'before' => '<div class="page-links">' . esc_html__('Sayfalar:', 'tutkuorg'),
                        'after'  => '</div>',
                    ));
                    ?>
                </div>

                <footer class="entry-footer" style="max-width: 900px; margin: 2rem auto 0; padding-top: 2rem; border-top: 2px solid var(--light-gray);">
                    <div class="entry-meta">
                        <?php
                        $categories_list = get_the_category_list(esc_html__(', ', 'tutkuorg'));
                        if ($categories_list) {
                            printf('<span class="cat-links"><i class="fas fa-folder"></i> %s</span>', $categories_list);
                        }

                        $tags_list = get_the_tag_list('', esc_html_x(', ', 'list item separator', 'tutkuorg'));
                        if ($tags_list) {
                            printf('<span class="tags-links" style="margin-left: 1.5rem;"><i class="fas fa-tags"></i> %s</span>', $tags_list);
                        }
                        ?>
                    </div>
                </footer>
            </div>
        </article>

        <?php
        // Previous/next post navigation.
        the_post_navigation(array(
            'prev_text' => '<span class="nav-subtitle"><i class="fas fa-arrow-left"></i> Önceki Yazı</span> <span class="nav-title">%title</span>',
            'next_text' => '<span class="nav-subtitle">Sonraki Yazı <i class="fas fa-arrow-right"></i></span> <span class="nav-title">%title</span>',
        ));

        // If comments are open or we have at least one comment, load up the comment template.
        if (comments_open() || get_comments_number()) :
            comments_template();
        endif;

    endwhile; // End of the loop.
    ?>
</main>

<?php
get_footer();
?>

