# Muhabbetci.com Chat Teması

> **Kaan Yavuz imzasıyla ✍️**

## 📋 Proje Hakkında

Muhabbetci.com'un klasik sohbet temasından ilham alınarak oluşturulmuş, basit ve işlevsel bir online sohbet platformu temasıdır. Minimalist tasarım ve hızlı yükleme özellikleri ile öne çıkar.

## ✨ Özellikler

- 🎨 **Muhabbetci.com Benzeri Tasarım** - Mavi/beyaz renk şeması
- 📱 **Tamamen Responsive** - Mobil uyumlu
- 💬 **Basit Sohbet Odası** - Klasik chat görünümü
- 👥 **Online Kullanıcı Listesi** - Sidebar'da aktif kullanıcılar
- 📊 **İstatistikler** - Anlık kullanıcı sayıları
- 🏠 **Sohbet Odaları** - 6 farklı kategori
- ⚡ **Hızlı ve Hafif** - Optimize edilmiş kod
- 🎯 **Minimalist** - Gereksiz öğeler yok

## 📁 Dosya Yapısı

```
muhabbet-tema/
├── index.html          # Ana sayfa
├── chat.html           # Sohbet odası
├── README.md           # Proje dokümantasyonu
│
└── assets/
    └── style.css       # Muhabbetci.com teması CSS
```

## 🚀 Kurulum

1. Projeyi bilgisayarınıza indirin
2. `index.html` dosyasını bir tarayıcıda açın veya bir web sunucusunda çalıştırın

### Yerel Sunucu ile Çalıştırma

**Python ile:**
```bash
cd muhabbet-tema
python -m http.server 8000
```

**Node.js ile:**
```bash
cd muhabbet-tema
npx http-server
```

Tarayıcınızda `http://localhost:8000` adresine gidin.

## 🎨 Renk Paleti

- **Ana Mavi:** `#0066CC`
- **Koyu Mavi:** `#004499`
- **Açık Mavi:** `#E6F2FF`
- **Beyaz:** `#FFFFFF`
- **Gri:** `#F5F5F5`
- **Koyu:** `#333333`
- **Yeşil:** `#00AA00` (Online durumu)
- **Turuncu:** `#FF6600`

## 📱 Sayfalar

### Ana Sayfa (index.html)
- Header ile logo ve navigasyon
- Hoş geldiniz kutusu
- İstatistik kartları (4 adet)
- Sohbet odaları listesi (6 oda)
- Hakkımızda bölümü

### Sohbet Odası (chat.html)
- Sol sidebar: Online kullanıcılar
- Ana alan: Sohbet mesajları
- Alt kısım: Mesaj gönderme formu
- Muhabbetci.com benzeri temiz tasarım

## 🔧 Özellikler

### Ana Sayfa
- ✅ Basit ve temiz header
- ✅ Hoş geldiniz kutusu
- ✅ İstatistik kartları
- ✅ Sohbet odası listesi
- ✅ Her oda için online sayısı
- ✅ Hakkımızda bölümü

### Sohbet Odası
- ✅ Online kullanıcı listesi
- ✅ Real-time mesaj görünümü
- ✅ Kullanıcı avatarları
- ✅ Mesaj bubble tasarımı (mavi/beyaz)
- ✅ Otomatik scroll
- ✅ Bot cevap simülasyonu
- ✅ Minimalist tasarım

## 🎯 Gelecek Özellikler

- [ ] Backend entegrasyonu
- [ ] Gerçek zamanlı mesajlaşma (WebSocket)
- [ ] Kullanıcı kayıt ve giriş
- [ ] Profil sayfaları
- [ ] Dosya paylaşımı
- [ ] Sesli mesajlar
- [ ] Emoji picker
- [ ] Tema değiştirme

## 📝 Lisans

Bu proje, Kaan Yavuz imzasıyla hazırlanmıştır.

## 🤝 Katkıda Bulunma

Önerileriniz ve geri bildirimleriniz için:

**E-posta:** iletisim@muhabbetci.com

## 📞 İletişim

- **Web:** muhabbetci.com
- **Geliştirici:** Kaan Yavuz ✍️

---

**© 2024 Muhabbetci.com | Kaan Yavuz imzasıyla ✍️**

