// 18 Yaş Doğrulama Sistemi
(function() {
    // Yaş onayı localStorage'da var mı kontrol et
    const ageVerified = localStorage.getItem('ageVerified');
    
    if (ageVerified !== 'true') {
        // Modal oluştur
        const modal = document.createElement('div');
        modal.id = 'age-verification-modal';
        modal.style.cssText = `
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.9);
            z-index: 99999;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: Arial, sans-serif;
        `;
        
        modal.innerHTML = `
            <div style="background: white; padding: 40px; border-radius: 15px; max-width: 500px; width: 90%; text-align: center; box-shadow: 0 10px 40px rgba(0,0,0,0.5);">
                <div style="font-size: 48px; margin-bottom: 20px;">🚫</div>
                <h2 style="color: #d32f2f; margin: 0 0 15px 0; font-size: 28px;">YASAL UYARI</h2>
                <p style="color: #333; font-size: 20px; font-weight: bold; margin: 0 0 20px 0; line-height: 1.6;">
                    18 YAŞINDAN KÜÇÜKLERİN GİRMESİ YASAKTIR!
                </p>
                <p style="color: #666; font-size: 16px; margin: 0 0 30px 0; line-height: 1.6;">
                    Bu site yalnızca 18 yaş ve üzeri kullanıcılar içindir. 
                    Siteye erişmek için aşağıdaki kutuyu işaretleyerek yaşınızı doğrulamanız gerekmektedir.
                </p>
                <div style="margin-bottom: 25px;">
                    <label style="display: flex; align-items: center; justify-content: center; gap: 10px; cursor: pointer; font-size: 18px; color: #333;">
                        <input type="checkbox" id="age-checkbox" style="width: 24px; height: 24px; cursor: pointer;">
                        <span>18 yaşından büyük olduğumu onaylıyorum</span>
                    </label>
                </div>
                <div style="display: flex; gap: 15px; justify-content: center;">
                    <button id="age-confirm-btn" disabled style="
                        background: #4CAF50;
                        color: white;
                        border: none;
                        padding: 15px 40px;
                        font-size: 18px;
                        font-weight: bold;
                        border-radius: 8px;
                        cursor: pointer;
                        transition: background 0.3s ease;
                        opacity: 0.5;
                    ">GİRİŞ YAP</button>
                    <button id="age-cancel-btn" onclick="window.location.href='about:blank'" style="
                        background: #f44336;
                        color: white;
                        border: none;
                        padding: 15px 40px;
                        font-size: 18px;
                        font-weight: bold;
                        border-radius: 8px;
                        cursor: pointer;
                        transition: background 0.3s ease;
                    ">ÇIKIŞ</button>
                </div>
            </div>
        `;
        
        document.body.appendChild(modal);
        document.body.style.overflow = 'hidden';
        
        const checkbox = document.getElementById('age-checkbox');
        const confirmBtn = document.getElementById('age-confirm-btn');
        
        // Checkbox değişikliğini dinle
        checkbox.addEventListener('change', function() {
            if (this.checked) {
                confirmBtn.disabled = false;
                confirmBtn.style.opacity = '1';
                confirmBtn.style.background = '#4CAF50';
            } else {
                confirmBtn.disabled = true;
                confirmBtn.style.opacity = '0.5';
            }
        });
        
        // Onay butonuna tıklama
        confirmBtn.addEventListener('click', function() {
            if (checkbox.checked) {
                localStorage.setItem('ageVerified', 'true');
                modal.remove();
                document.body.style.overflow = '';
            }
        });
        
        // Çıkış butonuna tıklama
        document.getElementById('age-cancel-btn').addEventListener('mouseover', function() {
            this.style.background = '#d32f2f';
        });
        
        document.getElementById('age-cancel-btn').addEventListener('mouseout', function() {
            this.style.background = '#f44336';
        });
        
        confirmBtn.addEventListener('mouseover', function() {
            if (!this.disabled) {
                this.style.background = '#45a049';
            }
        });
        
        confirmBtn.addEventListener('mouseout', function() {
            if (!this.disabled) {
                this.style.background = '#4CAF50';
            }
        });
    }
})();

// Odalara giriş kontrolü
document.addEventListener('DOMContentLoaded', function() {
    const roomLinks = document.querySelectorAll('a[href*="chat"], a.room-btn, a[href*="sohbet"], a[href*="mobil-giris"]');
    
    roomLinks.forEach(function(link) {
        link.addEventListener('click', function(e) {
            const ageVerified = localStorage.getItem('ageVerified');
            
            if (ageVerified !== 'true') {
                e.preventDefault();
                
                // Modal göster
                const modal = document.createElement('div');
                modal.id = 'age-verification-modal';
                modal.style.cssText = `
                    position: fixed;
                    top: 0;
                    left: 0;
                    width: 100%;
                    height: 100%;
                    background: rgba(0, 0, 0, 0.9);
                    z-index: 99999;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    font-family: Arial, sans-serif;
                `;
                
                modal.innerHTML = `
                    <div style="background: white; padding: 40px; border-radius: 15px; max-width: 500px; width: 90%; text-align: center; box-shadow: 0 10px 40px rgba(0,0,0,0.5);">
                        <div style="font-size: 48px; margin-bottom: 20px;">🚫</div>
                        <h2 style="color: #d32f2f; margin: 0 0 15px 0; font-size: 28px;">YASAL UYARI</h2>
                        <p style="color: #333; font-size: 20px; font-weight: bold; margin: 0 0 20px 0; line-height: 1.6;">
                            18 YAŞINDAN KÜÇÜKLERİN GİRMESİ YASAKTIR!
                        </p>
                        <p style="color: #666; font-size: 16px; margin: 0 0 30px 0; line-height: 1.6;">
                            Bu sohbet odasına girmek için 18 yaşından büyük olduğunuzu onaylamanız gerekmektedir.
                        </p>
                        <div style="margin-bottom: 25px;">
                            <label style="display: flex; align-items: center; justify-content: center; gap: 10px; cursor: pointer; font-size: 18px; color: #333;">
                                <input type="checkbox" id="age-checkbox-room" style="width: 24px; height: 24px; cursor: pointer;">
                                <span>18 yaşından büyük olduğumu onaylıyorum</span>
                            </label>
                        </div>
                        <div style="display: flex; gap: 15px; justify-content: center;">
                            <button id="age-confirm-btn-room" disabled style="
                                background: #4CAF50;
                                color: white;
                                border: none;
                                padding: 15px 40px;
                                font-size: 18px;
                                font-weight: bold;
                                border-radius: 8px;
                                cursor: pointer;
                                transition: background 0.3s ease;
                                opacity: 0.5;
                            ">DEVAM ET</button>
                            <button id="age-cancel-btn-room" onclick="this.closest('#age-verification-modal').remove(); document.body.style.overflow=''" style="
                                background: #f44336;
                                color: white;
                                border: none;
                                padding: 15px 40px;
                                font-size: 18px;
                                font-weight: bold;
                                border-radius: 8px;
                                cursor: pointer;
                                transition: background 0.3s ease;
                            ">İPTAL</button>
                        </div>
                    </div>
                `;
                
                document.body.appendChild(modal);
                document.body.style.overflow = 'hidden';
                
                const checkbox = document.getElementById('age-checkbox-room');
                const confirmBtn = document.getElementById('age-confirm-btn-room');
                const originalHref = link.href;
                
                checkbox.addEventListener('change', function() {
                    if (this.checked) {
                        confirmBtn.disabled = false;
                        confirmBtn.style.opacity = '1';
                        confirmBtn.style.background = '#4CAF50';
                    } else {
                        confirmBtn.disabled = true;
                        confirmBtn.style.opacity = '0.5';
                    }
                });
                
                confirmBtn.addEventListener('click', function() {
                    if (checkbox.checked) {
                        localStorage.setItem('ageVerified', 'true');
                        modal.remove();
                        document.body.style.overflow = '';
                        window.location.href = originalHref;
                    }
                });
                
                document.getElementById('age-cancel-btn-room').addEventListener('mouseover', function() {
                    this.style.background = '#d32f2f';
                });
                
                document.getElementById('age-cancel-btn-room').addEventListener('mouseout', function() {
                    this.style.background = '#f44336';
                });
                
                confirmBtn.addEventListener('mouseover', function() {
                    if (!this.disabled) {
                        this.style.background = '#45a049';
                    }
                });
                
                confirmBtn.addEventListener('mouseout', function() {
                    if (!this.disabled) {
                        this.style.background = '#4CAF50';
                    }
                });
            }
        });
    });
});

