// Kaan Yavuz Koruması - Silinince site bozulsun
(function() {
    const protectedName = '4b61616e20596176757a'; // "Kaan Yavuz" hex encoded
    const signatureElement = document.getElementById('signature-protected');
    
    if (!signatureElement) {
        document.body.innerHTML = '<h1 style="text-align:center;padding:50px;color:red;">Site koruma hatası!</h1>';
        document.body.style.background = '#fff';
        return;
    }
    
    // Korumalı ismi decode et
    function decodeHex(hex) {
        let decoded = '';
        for (let i = 0; i < hex.length; i += 2) {
            decoded += String.fromCharCode(parseInt(hex.substr(i, 2), 16));
        }
        return decoded;
    }
    
    try {
        const decoded = decodeHex(protectedName);
        signatureElement.textContent = decoded + ' Tarafından Yapılmıştır';
    } catch(e) {
        document.body.innerHTML = '<h1 style="text-align:center;padding:50px;color:red;">Site koruma hatası!</h1>';
        document.body.style.background = '#fff';
        return;
    }
    
    // İsim silinirse kontrol et
    setInterval(function() {
        if (!signatureElement || !signatureElement.textContent || !signatureElement.textContent.includes('Kaan Yavuz')) {
            document.body.innerHTML = '<h1 style="text-align:center;padding:50px;color:red;">Site koruma hatası! İçerik değiştirilemez.</h1>';
            document.body.style.background = '#fff';
        }
    }, 500);
    
    // DOM değişikliklerini kontrol et
    const observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            if (mutation.target === signatureElement) {
                if (!signatureElement.textContent.includes('Kaan Yavuz')) {
                    document.body.innerHTML = '<h1 style="text-align:center;padding:50px;color:red;">Site koruma hatası! İçerik değiştirilemez.</h1>';
                    document.body.style.background = '#fff';
                }
            }
        });
    });
    
    observer.observe(signatureElement, {
        childList: true,
        subtree: true,
        characterData: true
    });
})();

