<?php
/**
 * The template for displaying archive pages
 *
 * @package TutkuSohbet
 */

get_header();
?>

<main id="main" class="site-main">
    <section class="features-section">
        <div class="container">
            <div class="section-header">
                <h2 class="section-title"><?php the_archive_title(); ?></h2>
                <?php if (the_archive_description()) : ?>
                    <p class="section-subtitle"><?php the_archive_description(); ?></p>
                <?php endif; ?>
            </div>
            
            <?php if (have_posts()) : ?>
                <div class="features-grid">
                    <?php
                    while (have_posts()) :
                        the_post();
                    ?>
                        <a href="<?php the_permalink(); ?>" style="text-decoration: none; color: inherit;">
                            <div class="feature-card">
                                <?php if (has_post_thumbnail()) : ?>
                                    <div style="margin-bottom: 1rem;">
                                        <?php the_post_thumbnail('medium', array('style' => 'width: 100%; height: 200px; object-fit: cover; border-radius: 10px;')); ?>
                                    </div>
                                <?php endif; ?>
                                <h3 class="feature-title"><?php the_title(); ?></h3>
                                <p class="feature-description"><?php echo wp_trim_words(get_the_excerpt(), 20); ?></p>
                                <span class="feature-btn">Devamını Oku</span>
                            </div>
                        </a>
                    <?php
                    endwhile;
                    ?>
                </div>
                
                <?php
                the_posts_pagination(array(
                    'prev_text' => '<i class="fas fa-arrow-left"></i> Önceki',
                    'next_text' => 'Sonraki <i class="fas fa-arrow-right"></i>',
                ));
                ?>
            <?php else : ?>
                <div class="login-box">
                    <p>Henüz içerik bulunmamaktadır.</p>
                </div>
            <?php endif; ?>
        </div>
    </section>
</main>

<?php
get_footer();
?>

