// Mobile Menu Toggle
document.addEventListener('DOMContentLoaded', function() {
    const mobileMenuToggle = document.getElementById('mobileMenuToggle');
    const nav = document.querySelector('.nav');

    if (mobileMenuToggle) {
        mobileMenuToggle.addEventListener('click', () => {
            nav.classList.toggle('mobile-active');
        });
    }

    // Login Form Handler
    const loginForm = document.getElementById('loginForm');
    if (loginForm) {
        loginForm.addEventListener('submit', (e) => {
            e.preventDefault();
            const username = document.getElementById('username').value;
            const password = document.getElementById('password').value;
            
            if (username) {
                // Save username to localStorage
                localStorage.setItem('chatUsername', username);
                // Redirect to chat page
                window.location.href = '/Mobil/';
            } else {
                alert('Lütfen kullanıcı adınızı girin!');
            }
        });
    }

    // Decode and show design credit (UTF-8 support for Turkish characters)
    const decodeDesignCredit = () => {
        const designCredits = document.querySelectorAll('.design-credit');
        designCredits.forEach(credit => {
            const encoded = credit.getAttribute('data-encoded');
            if (encoded) {
                try {
                    const decoded = decodeURIComponent(escape(atob(encoded)));
                    credit.innerHTML = `<span class="design-credit-name">${decoded}</span>`;
                    setTimeout(() => {
                        credit.classList.add('show');
                    }, 500);
                } catch (e) {
                    try {
                        const binaryString = atob(encoded);
                        const bytes = new Uint8Array(binaryString.length);
                        for (let i = 0; i < binaryString.length; i++) {
                            bytes[i] = binaryString.charCodeAt(i);
                        }
                        const decoder = new TextDecoder('utf-8');
                        const decoded = decoder.decode(bytes);
                        credit.innerHTML = `<span class="design-credit-name">${decoded}</span>`;
                        setTimeout(() => {
                            credit.classList.add('show');
                        }, 500);
                    } catch (e2) {
                        credit.innerHTML = '<span class="design-credit-name">Kaan Yavuz</span>';
                        setTimeout(() => {
                            credit.classList.add('show');
                        }, 500);
                    }
                }
            }
        });
    };

    decodeDesignCredit();

    // Smooth Scroll
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });

    // Animate on scroll
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
            }
        });
    }, observerOptions);

    // Observe feature cards
    document.querySelectorAll('.feature-card').forEach(card => {
        card.style.opacity = '0';
        card.style.transform = 'translateY(30px)';
        card.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
        observer.observe(card);
    });
});

console.log('TutkuSohbet.com.tr WordPress yüklendi! 💬');

