<!-- Footer -->
<footer class="footer">
    <div class="container">
        <div class="footer-content">
            <div class="footer-section">
                <h4 class="footer-title"><?php bloginfo('name'); ?></h4>
                <p class="footer-description"><?php bloginfo('description'); ?></p>
            </div>
            <div class="footer-section">
                <h4 class="footer-title">Hızlı Linkler</h4>
                <ul class="footer-links">
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'footer',
                        'container' => false,
                        'menu_class' => 'footer-links',
                        'fallback_cb' => 'tutkusohbet_footer_menu',
                        'items_wrap' => '%3$s',
                    ));
                    ?>
                </ul>
            </div>
            <div class="footer-section">
                <h4 class="footer-title">İletişim</h4>
                <ul class="footer-contact">
                    <li>
                        <i class="fas fa-envelope"></i>
                        <a href="mailto:info@tutkusohbet.com.tr">info@tutkusohbet.com.tr</a>
                    </li>
                    <li>
                        <i class="fas fa-clock"></i>
                        <span>7/24 Aktif</span>
                    </li>
                </ul>
            </div>
        </div>
        <div class="footer-bottom">
            <p>&copy; <?php echo date('Y'); ?> <?php bloginfo('name'); ?>. Tüm hakları saklıdır.</p>
            <p class="design-credit" data-encoded="QnUgV2ViU2l0ZSBLYWFuIFlhdnV6IFRhcmHEsWZuZGFuIFlhcMSxbMSxcnR1cg=="></p>
        </div>
    </div>
</footer>

<?php wp_footer(); ?>
</body>
</html>

<?php
// Default footer menu
function tutkusohbet_footer_menu() {
    echo '<li><a href="' . esc_url(home_url('/')) . '">Anasayfa</a></li>';
    $pages = get_pages(array('sort_column' => 'menu_order', 'number' => 5));
    foreach ($pages as $page) {
        echo '<li><a href="' . esc_url(get_permalink($page->ID)) . '">' . esc_html($page->post_title) . '</a></li>';
    }
}
?>

