<?php
/**
 * The front page template file
 *
 * @package TutkuSohbet
 */

get_header();
?>

<!-- Hero Section -->
<section class="hero">
    <div class="hero-overlay"></div>
    <div class="container">
        <div class="hero-content">
            <h1 class="hero-title">Ne duruyorsun? Hemen sohbete başla :)</h1>
            <p class="hero-subtitle">Yeni arkadaşlıklar, dostluklar için buradayız</p>
            <div class="hero-buttons">
                <a href="<?php echo esc_url(home_url('/Mobil/')); ?>" class="btn btn-primary">
                    <i class="fas fa-comments"></i> Sohbete Bağlan
                </a>
                <a href="<?php echo esc_url(home_url('/radyo/')); ?>" class="btn btn-secondary">
                    <i class="fas fa-radio"></i> Radyo Dinle
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Login Section -->
<section class="login-section">
    <div class="container">
        <div class="login-box">
            <h2 class="login-title">
                <i class="fas fa-user"></i> Güvenli Giriş
            </h2>
            <form class="login-form" id="loginForm">
                <div class="form-group">
                    <label for="username">Kullanıcı Adı</label>
                    <input type="text" id="username" name="username" placeholder="Kullanıcı adınızı girin" required>
                </div>
                <div class="form-group">
                    <label for="password">Şifre <span class="info-text">(Yoksa boş bırakın)</span></label>
                    <input type="password" id="password" name="password" placeholder="Şifrenizi girin">
                </div>
                <button type="submit" class="btn btn-primary btn-block">
                    <i class="fas fa-sign-in-alt"></i> Sohbete Bağlan
                </button>
            </form>
            <div class="login-options">
                <a href="<?php echo esc_url(home_url('/Mobil/')); ?>" class="btn btn-outline">Farklı Sürüm ile Bağlan</a>
            </div>
        </div>
    </div>
</section>

<!-- Features Section -->
<section class="features-section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">TutkuSohbet Ailesi</h2>
            <p class="section-subtitle">Bedava sohbet odaları ve daha fazlası</p>
        </div>
        <div class="features-grid">
            <a href="<?php echo esc_url(home_url('/Mobil/')); ?>" style="text-decoration: none; color: inherit;">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-comments"></i>
                    </div>
                    <h3 class="feature-title">Sohbet Et!</h3>
                    <p class="feature-description">Tutku tadında sohbet</p>
                    <span class="feature-btn">Hızlı Bağlan</span>
                </div>
            </a>
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-radio"></i>
                </div>
                <h3 class="feature-title">Radyo Dinle</h3>
                <p class="feature-description">TutkuFM</p>
                <a href="<?php echo esc_url(home_url('/radyo/')); ?>" class="feature-btn">Radyo Aç</a>
            </div>
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-download"></i>
                </div>
                <h3 class="feature-title">mIRC İndir</h3>
                <p class="feature-description">mIRC Download</p>
                <a href="http://kirazsohbet.com/mirc.rar" class="feature-btn">İndir</a>
            </div>
        </div>
    </div>
</section>

<!-- Cities Section -->
<section class="cities-section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-map-marker-alt"></i> Şehir Listesi
            </h2>
            <p class="section-subtitle">Şehrinizi seçin ve o şehirden insanlarla sohbet edin!</p>
        </div>
        <div class="cities-grid">
            <?php
            $cities = tutkusohbet_get_cities();
            $counter = 1;
            foreach ($cities as $city) :
            ?>
            <a href="<?php echo esc_url(home_url($city['link'])); ?>" class="city-card" data-city="<?php echo esc_attr($city['name']); ?>">
                <div class="city-icon">
                    <i class="fas fa-city"></i>
                </div>
                <h3 class="city-name"><?php echo esc_html($city['name']); ?></h3>
                <p class="city-users">
                    <i class="fas fa-users"></i> <span class="user-count"><?php echo esc_html($city['users']); ?></span> Kullanıcı
                </p>
            </a>
            <?php
            $counter++;
            endforeach;
            ?>
        </div>
    </div>
</section>

<!-- Info Section -->
<section class="info-section">
    <div class="container">
        <div class="info-content">
            <div class="info-text">
                <h2 class="info-title">TutkuSohbet ailesi olarak, sadece mesajlaşmakla kalmayıp, duyguların, dertlerin, sevinçlerin ve kahkahaların paylaşıldığı samimi bir ortam oluşturduk. Gel, sen de bu sıcak ortama katıl!</h2>
                <p class="info-description">TutkuSohbet.Com IRC Network - Bedava sohbet odaları</p>
            </div>
        </div>
    </div>
</section>

<?php
get_footer();
?>

