<?php
/**
 * TutkuSohbet Theme Functions
 *
 * @package TutkuSohbet
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Theme Setup
 */
function tutkusohbet_setup() {
    // Add theme support
    add_theme_support('title-tag');
    add_theme_support('post-thumbnails');
    add_theme_support('html5', array(
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
    ));
    add_theme_support('custom-logo');
    add_theme_support('automatic-feed-links');
    
    // Register navigation menus
    register_nav_menus(array(
        'primary' => __('Primary Menu', 'tutkusohbet'),
        'footer' => __('Footer Menu', 'tutkusohbet'),
    ));
}
add_action('after_setup_theme', 'tutkusohbet_setup');

/**
 * Enqueue scripts and styles
 */
function tutkusohbet_scripts() {
    // Enqueue Font Awesome
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css', array(), '6.4.0');
    
    // Enqueue theme stylesheet
    wp_enqueue_style('tutkusohbet-style', get_stylesheet_uri(), array(), '1.0.0');
    
    // Enqueue theme JavaScript
    wp_enqueue_script('tutkusohbet-main', get_template_directory_uri() . '/assets/js/main.js', array(), '1.0.0', true);
    
    // Localize script for AJAX
    wp_localize_script('tutkusohbet-main', 'tutkusohbetData', array(
        'ajaxUrl' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('tutkusohbet-nonce'),
    ));
}
add_action('wp_enqueue_scripts', 'tutkusohbet_scripts');

/**
 * Register widget areas
 */
function tutkusohbet_widgets_init() {
    register_sidebar(array(
        'name' => __('Sidebar', 'tutkusohbet'),
        'id' => 'sidebar-1',
        'description' => __('Add widgets here.', 'tutkusohbet'),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget' => '</section>',
        'before_title' => '<h2 class="widget-title">',
        'after_title' => '</h2>',
    ));
}
add_action('widgets_init', 'tutkusohbet_widgets_init');

/**
 * Custom excerpt length
 */
function tutkusohbet_excerpt_length($length) {
    return 30;
}
add_filter('excerpt_length', 'tutkusohbet_excerpt_length');

/**
 * Custom excerpt more
 */
function tutkusohbet_excerpt_more($more) {
    return '...';
}
add_filter('excerpt_more', 'tutkusohbet_excerpt_more');

/**
 * Get cities list for front page
 */
function tutkusohbet_get_cities() {
    return array(
        array('name' => 'İstanbul', 'users' => '1,234', 'link' => '/Mobil/'),
        array('name' => 'Ankara', 'users' => '856', 'link' => '/Mobil/'),
        array('name' => 'İzmir', 'users' => '742', 'link' => '/Mobil/'),
        array('name' => 'Bursa', 'users' => '623', 'link' => '/Mobil/'),
        array('name' => 'Antalya', 'users' => '589', 'link' => '/Mobil/'),
        array('name' => 'Adana', 'users' => '512', 'link' => '/Mobil/'),
        array('name' => 'Gaziantep', 'users' => '478', 'link' => '/Mobil/'),
        array('name' => 'Konya', 'users' => '445', 'link' => '/Mobil/'),
        array('name' => 'Kayseri', 'users' => '398', 'link' => '/Mobil/'),
        array('name' => 'Trabzon', 'users' => '367', 'link' => '/Mobil/'),
        array('name' => 'Samsun', 'users' => '334', 'link' => '/Mobil/'),
        array('name' => 'Diyarbakır', 'users' => '312', 'link' => '/Mobil/'),
        array('name' => 'Eskişehir', 'users' => '289', 'link' => '/Mobil/'),
        array('name' => 'Mersin', 'users' => '256', 'link' => '/Mobil/'),
        array('name' => 'Denizli', 'users' => '234', 'link' => '/Mobil/'),
        array('name' => 'Malatya', 'users' => '198', 'link' => '/Mobil/'),
        array('name' => 'Manisa', 'users' => '167', 'link' => '/Mobil/'),
        array('name' => 'Sivas', 'users' => '145', 'link' => '/Mobil/'),
    );
}

/**
 * Add theme color meta tag
 */
function tutkusohbet_theme_color() {
    echo '<meta name="theme-color" content="#FF6B9D">';
}
add_action('wp_head', 'tutkusohbet_theme_color');

/**
 * Add favicon
 */
function tutkusohbet_favicon() {
    $favicon = 'data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 100 100\'%3E%3Cdefs%3E%3ClinearGradient id=\'grad\' x1=\'0%25\' y1=\'0%25\' x2=\'100%25\' y2=\'100%25\'%3E%3Cstop offset=\'0%25\' style=\'stop-color:%23FF6B9D;stop-opacity:1\' /%3E%3Cstop offset=\'50%25\' style=\'stop-color:%23A855F7;stop-opacity:1\' /%3E%3Cstop offset=\'100%25\' style=\'stop-color:%234ECDC4;stop-opacity:1\' /%3E%3C/linearGradient%3E%3C/defs%3E%3Ccircle cx=\'50\' cy=\'50\' r=\'45\' fill=\'url(%23grad)\'/%3E%3Cpath d=\'M50 35 C45 25, 30 25, 30 35 C30 45, 50 60, 50 60 C50 60, 70 45, 70 35 C70 25, 55 25, 50 35 Z\' fill=\'white\'/%3E%3C/svg%3E';
    echo '<link rel="icon" type="image/svg+xml" href="' . esc_url($favicon) . '">';
    echo '<link rel="apple-touch-icon" href="' . esc_url($favicon) . '">';
}
add_action('wp_head', 'tutkusohbet_favicon');

