<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0, user-scalable=yes">
    <meta name="description" content="<?php bloginfo('description'); ?>">
    <meta name="keywords" content="sohbet, chat, bedava sohbet, canlı sohbet, radyo dinle, TutkuSohbet, sohbet odaları, online sohbet">
    <meta name="author" content="TutkuSohbet">
    <meta name="robots" content="index, follow">
    <meta name="language" content="Turkish">
    <meta name="revisit-after" content="7 days">
    
    <?php if (is_singular() && has_post_thumbnail()) : ?>
        <meta property="og:image" content="<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'large')); ?>">
    <?php else : ?>
        <meta property="og:image" content="<?php echo esc_url(get_template_directory_uri() . '/assets/images/og-image.jpg'); ?>">
    <?php endif; ?>
    
    <meta property="og:type" content="<?php echo is_singular() ? 'article' : 'website'; ?>">
    <meta property="og:url" content="<?php echo esc_url(get_permalink()); ?>">
    <meta property="og:title" content="<?php echo esc_attr(wp_get_document_title()); ?>">
    <meta property="og:description" content="<?php echo esc_attr(get_bloginfo('description')); ?>">
    <meta property="og:locale" content="tr_TR">
    <meta property="og:site_name" content="<?php bloginfo('name'); ?>">
    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:url" content="<?php echo esc_url(get_permalink()); ?>">
    <meta name="twitter:title" content="<?php echo esc_attr(wp_get_document_title()); ?>">
    <meta name="twitter:description" content="<?php echo esc_attr(get_bloginfo('description')); ?>">
    
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="TutkuSohbet">
    
    <?php wp_head(); ?>
    
    <?php
    // Add structured data for homepage
    if (is_front_page()) :
    ?>
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebSite",
        "name": "<?php bloginfo('name'); ?>",
        "url": "<?php echo esc_url(home_url()); ?>",
        "description": "<?php echo esc_js(get_bloginfo('description')); ?>",
        "publisher": {
            "@type": "Organization",
            "name": "TutkuSohbet",
            "url": "<?php echo esc_url(home_url()); ?>"
        }
    }
    </script>
    <?php endif; ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<!-- Header -->
<header class="header">
    <div class="container">
        <div class="header-content">
            <a href="<?php echo esc_url(home_url('/')); ?>" class="logo">
                <i class="fas fa-heart" id="logoIcon"></i>
                <span class="logo-text">Tutku<strong>Sohbet</strong><span class="logo-domain">.com.tr</span></span>
            </a>
            <nav class="nav">
                <?php
                wp_nav_menu(array(
                    'theme_location' => 'primary',
                    'container' => false,
                    'menu_class' => '',
                    'fallback_cb' => 'tutkusohbet_default_menu',
                    'items_wrap' => '<ul>%3$s</ul>',
                ));
                ?>
            </nav>
            <button class="mobile-menu-toggle" id="mobileMenuToggle">
                <i class="fas fa-bars"></i>
            </button>
        </div>
    </div>
</header>

<?php
// Default menu if no menu is assigned
function tutkusohbet_default_menu() {
    echo '<ul>';
    echo '<li><a href="' . esc_url(home_url('/')) . '" class="' . (is_front_page() ? 'active' : '') . '">Anasayfa</a></li>';
    
    // Get pages
    $pages = get_pages(array('sort_column' => 'menu_order'));
    foreach ($pages as $page) {
        $page_url = get_permalink($page->ID);
        $is_active = (is_page($page->ID)) ? 'active' : '';
        echo '<li><a href="' . esc_url($page_url) . '" class="' . $is_active . '">' . esc_html($page->post_title) . '</a></li>';
    }
    echo '</ul>';
}
?>

