<?php
/**
 * The template for displaying all single posts
 *
 * @package TutkuSohbet
 */

get_header();
?>

<main id="main" class="site-main">
    <section class="login-section">
        <div class="container">
            <div class="login-box" style="max-width: 900px;">
                <?php
                while (have_posts()) :
                    the_post();
                ?>
                    <h1 class="section-title"><?php the_title(); ?></h1>
                    <div class="entry-meta" style="margin-bottom: 1.5rem; color: var(--gray);">
                        <span><i class="fas fa-calendar"></i> <?php echo get_the_date(); ?></span>
                        <span style="margin-left: 1rem;"><i class="fas fa-user"></i> <?php the_author(); ?></span>
                    </div>
                    <?php if (has_post_thumbnail()) : ?>
                        <div style="margin-bottom: 2rem;">
                            <?php the_post_thumbnail('large', array('style' => 'width: 100%; height: auto; border-radius: 15px;')); ?>
                        </div>
                    <?php endif; ?>
                    <div class="entry-content">
                        <?php the_content(); ?>
                    </div>
                    <div style="margin-top: 2rem; padding-top: 2rem; border-top: 1px solid var(--light-gray);">
                        <a href="<?php echo esc_url(get_permalink(get_option('page_for_posts'))); ?>" class="btn btn-primary">
                            <i class="fas fa-arrow-left"></i> Tüm Makalelere Dön
                        </a>
                    </div>
                <?php
                endwhile;
                ?>
            </div>
        </div>
    </section>
</main>

<?php
get_footer();
?>

